/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import rpgboss.model.Animation;
import rpgboss.model.Animation$;
import rpgboss.model.AnimationFlash;
import rpgboss.model.AnimationSound;
import rpgboss.model.AnimationVisual;
import rpgboss.model.MusicSlots$;
import rpgboss.model.SoundSpec;
import rpgboss.model.resource.Music;
import rpgboss.model.resource.Music$;
import rpgboss.model.resource.MusicMetadata;
import rpgboss.model.resource.MusicPlayer;
import rpgboss.player.InputMultiplexer;
import rpgboss.player.RpgScreen;
import rpgboss.player.RpgScreen$;
import rpgboss.player.ShakeManager;
import rpgboss.player.WindowManager;
import rpgboss.player.entity.AnimationPlayer;
import rpgboss.player.entity.AnimationPlayer$;
import rpgboss.player.entity.AnimationTarget;
import rpgboss.player.entity.FixedAnimationTarget;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class RpgScreen$class {
    public static AnimationPlayer playAnimation(RpgScreen $this, int animationId, AnimationTarget target, float speedScale, float sizeScale) {
        Animation animation = $this.project().data().enums().animations()[animationId];
        AnimationPlayer player = new AnimationPlayer($this.project(), animation, $this.assets(), target, speedScale, sizeScale);
        player.play();
        $this.windowManager().animationManager().addAnimation(player);
        return player;
    }

    public static void playMusic(RpgScreen $this, int slot, Option specOpt, boolean loop2, float fadeDuration) {
        $this.assertOnBoundThread();
        if (slot < 0 || slot >= MusicSlots$.MODULE$.NUM_SLOTS()) {
            return;
        }
        $this.musics()[slot].map(new Serializable($this, fadeDuration){
            private final /* synthetic */ RpgScreen $outer;
            private final float fadeDuration$1;

            public final void apply(MusicPlayer oldMusic) {
                this.$outer.oldMusics().add(oldMusic);
                oldMusic.volumeTweener().tweenTo(BoxesRunTime.boxToFloat(0.0f), this.fadeDuration$1);
                oldMusic.volumeTweener().runAfterDone((Function0<BoxedUnit>)((Object)new Serializable(this, oldMusic){
                    private final /* synthetic */ RpgScreen$.anonfun.playMusic.1 $outer;
                    private final MusicPlayer oldMusic$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.oldMusic$1.stop();
                        this.oldMusic$1.dispose();
                        this.$outer.rpgboss$player$RpgScreen$$anonfun$$$outer().oldMusics().remove(this.oldMusic$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.oldMusic$1 = oldMusic$1;
                    }
                }));
            }

            public /* synthetic */ RpgScreen rpgboss$player$RpgScreen$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fadeDuration$1 = fadeDuration$1;
            }
        });
        $this.musics()[slot] = specOpt.map(new Serializable($this, loop2, fadeDuration){
            private final /* synthetic */ RpgScreen $outer;
            private final boolean loop$1;
            private final float fadeDuration$1;

            /*
             * WARNING - void declaration
             */
            public final MusicPlayer apply(SoundSpec spec) {
                void var3_3;
                Music resource = (Music)Music$.MODULE$.readFromDisk(this.$outer.project(), spec.sound(), ManifestFactory$.MODULE$.classType(MusicMetadata.class));
                MusicPlayer newMusic = resource.newPlayer(this.$outer.assets());
                newMusic.stop();
                newMusic.setVolume(0.0f);
                newMusic.setLooping(this.loop$1);
                newMusic.play();
                newMusic.volumeTweener().tweenTo(BoxesRunTime.boxToFloat(spec.volume()), this.fadeDuration$1);
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.loop$1 = loop$1;
                this.fadeDuration$1 = fadeDuration$1;
            }
        });
    }

    public static void playSound(RpgScreen $this, SoundSpec soundSpec) {
        $this.animationSound_$eq(new AnimationSound(0.0f, soundSpec));
        AnimationSound[] x$13 = (AnimationSound[])((Object[])new AnimationSound[]{$this.animationSound()});
        String x$14 = Animation$.MODULE$.apply$default$1();
        AnimationVisual[] x$15 = Animation$.MODULE$.apply$default$2();
        AnimationFlash[] x$16 = Animation$.MODULE$.apply$default$4();
        $this.animation_$eq(new Animation(x$14, x$15, x$13, x$16));
        $this.soundPlayer_$eq(new AnimationPlayer($this.project(), $this.animation(), $this.assets(), new FixedAnimationTarget(0.0f, 0.0f), AnimationPlayer$.MODULE$.$lessinit$greater$default$5(), AnimationPlayer$.MODULE$.$lessinit$greater$default$6()));
        $this.windowManager().animationManager().addAnimation($this.soundPlayer());
        $this.soundPlayer().play();
    }

    public static void stopSound(RpgScreen $this) {
        if ($this.soundPlayer() instanceof AnimationPlayer) {
            $this.soundPlayer().stop();
        }
    }

    public static void reset(RpgScreen $this) {
        $this.windowManager().reset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.musics().length).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable($this){
            private final /* synthetic */ RpgScreen $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.musics()[i].map(new Serializable(this){

                    public final void apply(MusicPlayer x$1) {
                        x$1.stop();
                    }
                });
                this.$outer.musics()[i].map(new Serializable(this){

                    public final void apply(MusicPlayer x$2) {
                        x$2.dispose();
                    }
                });
                this.$outer.musics()[i] = None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.oldMusics().foreach(new Serializable($this){

            public final void apply(MusicPlayer x$3) {
                x$3.dispose();
            }
        });
        $this.oldMusics().clear();
    }

    public static void dispose(RpgScreen $this) {
        $this.reset();
        $this.windowManager().dispose();
        if ($this.shapeRenderer() != null) {
            $this.shapeRenderer().dispose();
        }
        if ($this.batch() != null) {
            $this.batch().dispose();
        }
    }

    public static void hide(RpgScreen $this) {
        $this.assertOnBoundThread();
        $this.inputs().releaseAllKeys();
        Gdx.input.setInputProcessor(null);
        $this.windowManager().transitionAlpha_$eq(1.0f);
        Predef$.MODULE$.refArrayOps((Object[])$this.musics()).foreach(new Serializable($this){

            public final Option<BoxedUnit> apply(Option<MusicPlayer> x$4) {
                return x$4.map(new Serializable(this){

                    public final void apply(MusicPlayer x$5) {
                        x$5.pause();
                    }
                });
            }
        });
        $this.oldMusics().foreach(new Serializable($this){

            public final void apply(MusicPlayer x$6) {
                x$6.pause();
            }
        });
    }

    public static void pause(RpgScreen $this) {
        $this.assertOnBoundThread();
    }

    public static void render(RpgScreen $this, float delta) {
        $this.assertOnBoundThread();
        if ($this.assets().update()) {
            Predef$.MODULE$.refArrayOps((Object[])$this.musics()).foreach(new Serializable($this, delta){
                public final float delta$1;

                public final Option<BoxedUnit> apply(Option<MusicPlayer> x$7) {
                    return x$7.map(new Serializable(this){
                        private final /* synthetic */ RpgScreen$.anonfun.render.1 $outer;

                        public final void apply(MusicPlayer x$8) {
                            x$8.update(this.$outer.delta$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.delta$1 = delta$1;
                }
            });
            $this.oldMusics().foreach(new Serializable($this, delta){
                private final float delta$1;

                public final void apply(MusicPlayer x$9) {
                    x$9.update(this.delta$1);
                }
                {
                    this.delta$1 = delta$1;
                }
            });
            $this.windowManager().update(delta);
            if (!$this.windowManager().inTransition()) {
                $this.shakeManager().update(delta);
                $this.update(delta);
            }
            if (!$this.renderingOffForTesting()) {
                $this.render();
            }
            return;
        }
    }

    public static void resize(RpgScreen $this, int width, int height) {
        $this.assertOnBoundThread();
    }

    public static void resume(RpgScreen $this) {
        $this.assertOnBoundThread();
    }

    public static void show(RpgScreen $this) {
        $this.assertOnBoundThread();
        Gdx.input.setInputProcessor($this.inputs());
        Predef$.MODULE$.refArrayOps((Object[])$this.musics()).foreach(new Serializable($this){

            public final Option<BoxedUnit> apply(Option<MusicPlayer> x$10) {
                return x$10.map(new Serializable(this){

                    public final void apply(MusicPlayer x$11) {
                        x$11.play();
                    }
                });
            }
        });
        $this.oldMusics().foreach(new Serializable($this){

            public final void apply(MusicPlayer x$12) {
                x$12.play();
            }
        });
    }

    public static void $init$(RpgScreen $this) {
        $this.rpgboss$player$RpgScreen$_setter_$inputs_$eq(new InputMultiplexer());
        $this.rpgboss$player$RpgScreen$_setter_$musics_$eq((Option[])Array$.MODULE$.fill(MusicSlots$.MODULE$.NUM_SLOTS(), new Serializable($this){

            public final None$ apply() {
                return None$.MODULE$;
            }
        }, ClassTag$.MODULE$.apply(Option.class)));
        $this.rpgboss$player$RpgScreen$_setter_$batch_$eq($this.renderingOffForTesting() ? null : new SpriteBatch());
        $this.rpgboss$player$RpgScreen$_setter_$shapeRenderer_$eq($this.renderingOffForTesting() ? null : new ShapeRenderer());
        $this.rpgboss$player$RpgScreen$_setter_$oldMusics_$eq((Set)Set$.MODULE$.apply(Nil$.MODULE$));
        $this.rpgboss$player$RpgScreen$_setter_$screenCamera_$eq(new OrthographicCamera());
        $this.screenCamera().setToOrtho(true, $this.screenW(), $this.screenH());
        $this.screenCamera().update();
        $this.rpgboss$player$RpgScreen$_setter_$windowManager_$eq(new WindowManager($this.assets(), $this.project(), $this.screenW(), $this.screenH(), $this.renderingOffForTesting()));
        $this.rpgboss$player$RpgScreen$_setter_$shakeManager_$eq(new ShakeManager());
        $this.soundPlayer_$eq(null);
        $this.animationSound_$eq(null);
        $this.animation_$eq(null);
    }
}

